<div
    class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg p-6"
    x-data="{
                                editor: null,
                                initEditor() {
                                    Alpine.nextTick(() => {
                                        if (typeof Jodit === 'undefined') { return; }
                                        if (this.editor) this.editor.destruct();

                                        const wire = this.$wire;
                                        const addCommentButton = {
                                            tooltip: 'افزودن نظر روی متن انتخابی',
                                            icon: `<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' width='24' height='24' fill='none' stroke='currentColor' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'><path d='M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z'></path><line x1='12' y1='11' x2='12' y2='11'></line><line x1='16' y1='11' x2='16' y2='11'></line><line x1='8' y1='11' x2='8' y2='11'></line></svg>`,
                                            update(editor) {
                                                // [FIXED] Use the correct Jodit API methods
                                                const btn = editor.toolbar.buttons.find(b => b.name === 'addComment');
                                                if (btn) {
                                                    btn.state.disabled = editor.selection.isCollapsed();
                                                }
                                            },
                                            exec(editor) {
                                                const selectedHtml = editor.s.html;
                                                if (!selectedHtml) return;
                                                const anchorId = `comment-anchor-${Date.now()}`;
                                                const wrappedHtml = `<span id='${anchorId}' class='comment-highlight'>${selectedHtml}</span>`;
                                                editor.s.insertHTML(wrappedHtml);
                                                wire.startCommentOnSelection(anchorId);
                                            }
                                        };

                                        this.editor = Jodit.make(this.$refs.editor, {
                                            direction: 'rtl',
                                            language: 'fa',
                                            height: 400,
                                            controls: { addComment: addCommentButton },
                                            buttons: ['bold', 'italic', 'underline', '|', 'ul', 'ol', '|', 'image', 'table', 'link', '|', 'addComment', '|', 'undo', 'redo'],
                                        });

                                        this.editor.value = wire.get('body');
                                        this.editor.events.on('change.debounce', (newValue) => {
                                            wire.set('body', newValue, false);
                                        }, 500);
                                    });
                                }
                            }"
    x-init="initEditor()"
    @update-editor-content.window="if(editor) editor.value = $event.detail.content"
    {{-- [FIXED] Event listener with the correct Jodit API --}}
    @insert-chart-in-editor.window="
                                if (editor) {
                                    const imgHTML = `<img src='${$event.detail.imageData}' style='max-width: 100%; height: auto;'>`;
                                    editor.s.insertHTML(imgHTML);
                                }
                            "
    @insert-html-in-editor.window="
                                if (editor) {
                                    editor.focus(); // Force focus back to the editor
                                    // Use a small timeout to ensure the focus event has completed
                                    setTimeout(() => {
                                        editor.selection.insertHTML($event.detail.html);
                                    }, 50);
                                }
                            "
    @insert-text-in-editor.window="if(editor) { editor.s.insertHTML($event.detail.text); }"
>
